import requests
import json
import configparser
from Log_in import sign_in
"""
Use case 1:
This code demonstrates how to create a Location with Sectors
"""
sign_in_data = sign_in()
Token = sign_in_data[0]
url = sign_in_data[1]

def main():
    Location_Name = input("Enter the name of the new location: ")

    payload_Location = "{\n  \"name\": \"" + Location_Name + "\",\n  \"status\": \"enabled\"\n }"
    headers_Location = {
      'Authorization': 'Bearer ' + Token,
      'Content-Type': 'text/plain',
    }

    response = requests.request("POST", url + "/api/1.0/locations", headers=headers_Location, data=payload_Location)

    if response.status_code in [201]:
        print("new location " + Location_Name + " created")
    else:
        print(response.text)
        quit()

    line = json.loads(response.text)
    Location_id = (line["data"])["id"]

    Number_of_Sectors = input("How many sectors you wish to add to the Location " + Location_Name + ": ")
    Created_sectors = 0

    while Created_sectors < int(Number_of_Sectors):
        Created_sectors +=1
        Sector_Name = input("Enter the name of the new sector: ")
        payload = json.dumps({
        "name": Sector_Name,
        "location_id": int(Location_id),
        "status": "enabled",
        "manual_data_enabled": False
        })
        headers = {
        'Authorization': 'Bearer ' + Token
        }
        response = requests.request("POST", url + "/api/1.0/sectors", headers=headers, data=payload)

        if response.status_code in [201]:
            print("new sector " + Sector_Name + " was created in Location " + Location_Name)
        else:
            print(response.text)
            quit()

if __name__ == "__main__":
    main()
